//=============================================================================
// VendingMachine.
//=============================================================================
class BLWeaponVendor extends ElectronicDevices;

#exec OBJ LOAD FILE=Ambient

var int VendorLevel;

var BorderlandsWeapon Stock[10];
//var BorderlandsWeapon DealOfTheDay;


//var DeusExBaseWindow CurMenu;
var DeusExPlayer P;


var int MinLeft, SecLeft;
var String TimeString;

#exec AUDIO IMPORT FILE="Sounds\PurchaseFailure.wav" NAME="PurchaseFailure" GROUP="UI"
#exec AUDIO IMPORT FILE="Sounds\PurchaseSuccess.wav" NAME="PurchaseSuccess" GROUP="UI"

#exec TEXTURE IMPORT FILE="Textures\BLWeaponVendor.pcx" NAME="BLWeaponVendor" GROUP="Skins" MIPS=Off

function PlayErrorSound()
{
 PlaySound(Sound'PurchaseFailure');
}
function PlayPurchaseSound()
{
 PlaySound(Sound'PurchaseSuccess');
}
function PlayFullSound()
{
 PlaySound(Sound'PurchaseFailure');
}

function Timer()
{
 if (SecLeft > 0) SecLeft--;
 
 if (SecLeft <= 0)
 {
  if (MinLeft > 0)
  { 
   SecLeft = 59;
   MinLeft--;
  }
 }
 
 if (MinLeft <= 0 && SecLeft <= 0)
 {
  RandomizeStock();
  MinLeft = 10;
  SecLeft = 0;
 }
 
 if (SecLeft > 9) TimeString = MinLeft$":"$SecLeft;
 if (SecLeft < 10) TimeString = MinLeft$":0"$SecLeft;
 
 //if (CurMenu != None && CurMenu.IsA('BLMenuWeaponVendor')) BLMenuWeaponVendor(CurMenu).UpdateTimer(TimeString);
}

function RandomizeStock()
{
 local int i;
 
 for(i=0; i<10; i++)
 {
  if (Stock[i] != None && Stock[i].Owner == Self) Stock[i].Destroy();
  Stock[i] = RandomWeapon();
 }
 
 BroadcastMessage("|p4New Shop Inventory Available!");
 
 SortStock();
}

function SortStock()
{
 local BorderlandsWeapon W[10], BestW;
 local int V[10];
 local int i, j, Best, BestI;
 
 for(j=0; j<10; j++)
 {
  for(i=0; i<10; i++)
  {
   if (Stock[i] != None)
   {
    if (Best == 0 || GetColorLevel(Stock[i]) >= Best)
    {
     Best = GetColorLevel(Stock[i]);
     BestW = Stock[i];
     BestI = i;
    }
   }
  }
  
  Best = 0;
  W[j] = BestW;
  Stock[BestI] = None;
 }
 
 for(j=0; j<10; j++)
 {
  Stock[j] = W[j];
 }
 
 StealthStock();
 //DealOfTheDay = Stock[j];
}

function StealthStock()
{
 local int i;
 
 for(i=0; i<10; i++)
 {
  Stock[i].SetCollisionSize(0, 0);
  Stock[i].DrawScale = 0;
  Stock[i].Mesh = None;
  Stock[i].PickupViewMesh = None;
  Stock[i].PickupViewScale = 0;
 }
}

//isolated in case we need to change the method and not have
//brain heamoraging-ly complex code.
function int GetColorLevel(DeusExWeapon W)
{
 local int C;
 
 C = int(W.GetPropertyText("ColorRank"));
 
 return C;
}

function BorderlandsWeapon RandomWeapon()
{
 local int R;
 local BorderlandsWeapon W;
 
 R = Rand(7);
 
 if (R == 0)
 {
  W = Spawn(class'RandomShotgun',Self,,Location + vect(0,0,15), Rotation);
 }
 if (R == 1)
 {
  W = Spawn(class'RandomSniper',Self,,Location + vect(0,0,15), Rotation);
 }
 if (R == 2)
 {
  W = Spawn(class'RandomRepeater',Self,,Location + vect(0,0,15), Rotation);
 }
 if (R == 3)
 {
  W = Spawn(class'RandomRevolver',Self,,Location + vect(0,0,15), Rotation);
 }
 if (R == 4)
 {
  W = Spawn(class'RandomCobra',Self,,Location + vect(0,0,15), Rotation);
 }
 if (R == 5)
 {
  W = Spawn(class'RandomMachineGun',Self,,Location + vect(0,0,15), Rotation);
 }
 if (R == 6)
 {
  W = Spawn(class'RandomSMG',Self,,Location + vect(0,0,15), Rotation);
 }
 
 if (InStr(CAPS(W.ItemName), "|P7") > -1) BroadcastMessage("|p7Pearlscent Weapon For Sale!");
 
 W.SetPropertyText("WeaponLevel", FirstMutator().CurrentLevel);
 W.RandomizeStats();
 
 return W;
}

function MSBorderlandsMutator FirstMutator()
{
 local MSBorderlandsMutator M;
 
 forEach AllActors(class'MSBorderlandsMutator', M)
 {
  return M;
 }
}


function Frob(actor Frobber, Inventory frobWith)
{
 P = DeusExPlayer(Frobber);
 
 if (P != None) InvokeShopUI();
}

function DeusExBaseWindow InvokeShopUI()
{
  	local DeusExPlayer Player;
	local DeusExRootWindow root;
	local BLMenuWeaponVendor CusWindow;

	if(P != None)
	{
		P.InitRootWindow();
		root = DeusExRootWindow(P.rootWindow);
		if(root != None)
		{
			CusWindow = BLMenuWeaponVendor(root.InvokeUIScreen(Class'BLMenuWeaponVendor', True));
			if(CusWindow != None)
			{
				//CurMenu = CusWindow;
				CusWindow.Vendor = self;
				CusWindow.UpdateTimer(TimeString);
				CusWindow.SetTimings(MinLeft, SecLeft);
				CusWindow.ResetList();
			}
		}
	}

	return CusWindow;
}

defaultproperties
{
     bCanBeBase=True
     ItemName="Weapon Vendor"
     Mesh=LodMesh'DeusExDeco.VendingMachine'
     SoundRadius=8
     SoundVolume=96
     AmbientSound=Sound'Ambient.Ambient.HumLow3'
     CollisionRadius=34.000000
     CollisionHeight=50.000000
     Mass=150.000000
     Buoyancy=100.000000
     Multiskins(0)=Texture'BLWeaponVendor'
}
